# Courier Order Status Auto-Update System

## 📋 Overview

এই সিস্টেমটি **Pathao** এবং **Steadfast** কুরিয়ার থেকে অটোমেটিকভাবে order status check করে এবং admin panel এ status update করে।

## ✨ Features

- ✅ **Pathao Courier**: Order status check করে এবং auto-update করে
- ✅ **Steadfast Courier**: Order status check করে এবং auto-update করে
- ✅ **Auto Token Refresh**: Pathao token expired হলে automatically refresh করে
- ✅ **Scheduled Task**: প্রতি 10 মিনিটে automatically run হয়
- ✅ **Status Mapping**:
  - `delivered` → Order Status **6** (Completed)
  - `cancelled` → Order Status **11** (Cancelled)

## 🚀 Setup Instructions

### 1. Laravel Scheduler Setup

আপনার server এ **cron job** setup করতে হবে:

```bash
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

**Windows (XAMPP) এর জন্য:**
- Task Scheduler ব্যবহার করুন
- Command: `php C:\xampp\htdocs\artisan schedule:run`
- Frequency: প্রতি মিনিটে

### 2. Manual Test

Command manually test করতে:

```bash
php artisan courier:check-status
```

বা নির্দিষ্ট সংখ্যক order check করতে:

```bash
php artisan courier:check-status --limit=100
```

## 📊 How It Works

### Order Selection Criteria

Command শুধুমাত্র সেই orders check করবে যাদের:
- `order_status = 5` (Processing/Shipped)
- `courier_type` = `pathao` বা `steadfast`
- `courier_tracking_id` আছে (NULL না)

### Pathao Status Check

1. Pathao API endpoint: `/aladdin/api/v1/orders/{consignment_id}/info`
2. Response থেকে `order_status_slug` নেয়
3. Status mapping:
   - `delivered`, `completed` → Order Status **6**
   - `cancelled`, `canceled` → Order Status **11**

### Steadfast Status Check

1. Steadfast API endpoint: `/status_by_cid/{consignment_id}` বা `/status_by_invoice/{invoice}`
2. Response থেকে `delivery_status` নেয়
3. Status mapping:
   - `delivered`, `delivered_approval_pending` → Order Status **6**
   - `cancelled`, `cancelled_approval_pending` → Order Status **11**

## 🔧 Configuration

### Pathao Configuration

Admin Panel → **API Integration** → **Courier API Settings** → **Pathao**:
- ✅ API URL
- ✅ Client ID
- ✅ Client Secret
- ✅ Username/Email
- ✅ Password
- ✅ Access Token (auto-generated)

### Steadfast Configuration

Admin Panel → **API Integration** → **Courier API Settings** → **Steadfast**:
- ✅ API Key
- ✅ Secret Key
- ✅ API URL (default: `https://portal.packzy.com/api/v1`)

## 📝 Logs

সব activity `storage/logs/laravel.log` এ log হয়:

```php
// Success log
[INFO] Courier order status auto-updated
  - order_id: 123
  - invoice_id: INV-2024-001
  - courier_type: pathao
  - old_status: 5
  - new_status: 6

// Error log
[ERROR] Courier status check failed
  - order_id: 123
  - error: Token expired
```

## 🛠️ Troubleshooting

### Command Run হচ্ছে না

1. Check করুন `app/Console/Kernel.php` এ schedule properly configured আছে:
```php
$schedule->command('courier:check-status --limit=50')
    ->everyTenMinutes()
    ->withoutOverlapping()
    ->runInBackground();
```

2. Laravel scheduler running আছে কিনা check করুন:
```bash
php artisan schedule:list
```

### Pathao Token Expired

- Command automatically token refresh করার চেষ্টা করবে
- যদি refresh fail হয়, manually Admin Panel থেকে "Generate Token" button click করুন

### Steadfast API Error

- Check করুন API Key এবং Secret Key সঠিক আছে
- API URL সঠিক আছে কিনা verify করুন
- Steadfast API documentation check করুন

## 📈 Performance

- Default: প্রতি run এ **50 orders** check করে
- Frequency: **10 minutes**
- Overlap protection: `withoutOverlapping()` - একই সময়ে multiple instance run হবে না

## 🔐 Security

- API credentials database এ securely store হয়
- Logs এ sensitive information (password) log হয় না
- Token auto-refresh হলে new token save হয়

## 📞 Support

যদি কোনো সমস্যা হয়:
1. Check করুন `storage/logs/laravel.log`
2. Manual test করুন: `php artisan courier:check-status`
3. Courier API documentation verify করুন

---

**Created:** 2025-02-03  
**Version:** 1.0.0
